# Git Analytics Dashboard

A comprehensive git analytics dashboard for tracking team productivity, code quality, and development patterns across multiple repositories with centralized configuration management.

## ✨ Features

- **📊 Multi-Repository Support**: Manage and analyze multiple git repositories from one centralized dashboard
- **👥 Team Analytics**: Track contributor activity, working hours, and productivity patterns
- **🔍 Code Quality**: Monitor peer reviews, test coverage, and development practices
- **🚀 Delivery Metrics**: Measure lead times, feature vs bug ratios, and delivery velocity
- **📈 Visual Insights**: Interactive charts and detailed analytics tables
- **⚙️ Centralized Management**: Add repositories and edit configuration through web interface
- **🔧 Live Configuration**: Edit config.js directly in the browser with real-time updates
- **📱 Responsive Design**: Works seamlessly on desktop, tablet, and mobile devices

## 🚀 Quick Start

1. **Clone and Start**:
   ```bash
   git clone <repository-url>
   cd git-analytics-dashboard
   ./run.sh
   ```

2. **Access Dashboard**: Open http://localhost:3000

## 📋 Setup Guide

### 1. Add Repositories

1. Click **"⚙️ Manage Repos"** button (always visible in header)
2. Enter the **full path** to your git repository (e.g., `/Users/john/projects/my-repo`)
3. Give it a **display name** for easy identification
4. Click **"Add Repository"**

### 2. Configure Settings

1. Click **"🔧 Edit Config"** button (next to Manage Repos)
2. Edit configuration directly in the browser:
   - **JIRA Integration**: Set your JIRA base URL for ticket linking
   - **Business Hours**: Define working hours for your team
   - **Ticket Patterns**: Configure ticket ID patterns (e.g., PROJ-123)
   - **Branch Prefixes**: Set feature/, bugfix/, hotfix/ patterns
   - **Test Indicators**: Define what constitutes test files
3. Click **"Save Configuration"** and refresh the page

### 3. Generate Analytics Data

1. Click **"Generate Data"** for each repository
2. Or click **"🔄 Generate All Data"** to process all repositories at once
3. Wait for data generation to complete

### 4. View Analytics

1. Select a repository from the dropdown
2. Choose a year to filter data
3. Navigate through different analytics tabs:
   - **👥 Contributors**: Team productivity and activity
   - **🕘 Working Hours**: Work-life balance monitoring
   - **🔍 Peer Review**: Code review patterns
   - **🚀 Features & Bugs**: Development focus analysis
   - **🧪 Test Coverage**: Quality assurance tracking
   - **⏱️ Lead Time**: Delivery velocity metrics

## 🔧 Configuration Options

The configuration editor allows you to customize:

### Organization Settings
- **JIRA_BASE_URL**: Your JIRA instance URL for ticket linking
- **TICKET_PREFIXES**: Array of ticket prefixes (e.g., ["PROJ", "BUG", "FEAT"])

### Business Hours
- **BUSINESS_START_HOUR**: Start of business hours (default: 8)
- **BUSINESS_END_HOUR**: End of business hours (default: 17)
- **BUSINESS_DAYS_START**: First business day (1 = Monday)
- **BUSINESS_DAYS_END**: Last business day (5 = Friday)

### Development Patterns
- **FEATURE_PREFIX**: Branch prefix for features (default: "feature/")
- **BUGFIX_PREFIX**: Branch prefix for bug fixes (default: "bugfix/")
- **HOTFIX_PREFIX**: Branch prefix for hotfixes (default: "hotfix/")

### Quality Indicators
- **TEST_FILE_INDICATORS**: Array of patterns that indicate test files
- **LEAD_TIME_GOOD_THRESHOLD**: Days considered good lead time (default: 7)
- **LEAD_TIME_WARNING_THRESHOLD**: Days considered warning lead time (default: 14)

## 📊 Analytics Overview

### Contributors
- Monthly activity trends and patterns
- Lines of code by developer with rankings
- Productivity analysis and workload distribution

### Working Hours
- Business hours vs after-hours work analysis
- Work-life balance monitoring and alerts
- Overtime pattern identification and reporting

### Peer Review
- Code review distribution across team members
- Approval patterns and reviewer workload
- Review process optimization insights

### Features & Bug Fixes
- Feature vs bug fix ratios and trends
- Development focus tracking over time
- Quality trend analysis and alerts

### Test Coverage
- Test file presence detection and analysis
- Coverage gaps identification by ticket
- Quality assurance metrics and reporting

### Lead Time
- Development velocity measurement and trends
- Bottleneck identification in development process
- Process optimization insights and recommendations

## 🐳 Docker Commands

```bash
# Start with Docker
./run.sh

# Stop containers
docker-compose down

# View logs
docker-compose logs

# Rebuild containers
docker-compose up --build

# Access container shell
docker exec -it git-analytics-dashboard-git-analytics-1 sh
```

## 🛠️ Development

```bash
# Install dependencies
npm install

# Start development server with auto-reload
npm run dev

# Start production server
npm start

# Run with Docker for development
docker-compose up --build
```

## 📁 File Structure

```
git-analytics-dashboard/
├── index.html              # Main dashboard interface (generated from git_analytics_standalone.html)
├── git_analytics_standalone.html  # Source HTML file
├── config.js               # Configuration settings (editable via web interface)
├── server.js               # Node.js backend server with API endpoints
├── package.json            # Node.js dependencies and scripts
├── Dockerfile              # Docker container setup
├── docker-compose.yml      # Docker orchestration
├── run.sh                  # Docker startup script
├── start-local.sh          # Local Node.js startup script
├── git_data_*.txt          # Generated repository data files (one per repo)
└── README.md               # This documentation file
```

## 🔌 API Endpoints

The dashboard includes a RESTful API:

- **POST** `/api/generate-git-data` - Generate git analytics data for a repository
- **GET** `/api/data-files` - List all available data files
- **DELETE** `/api/data-files/:repoId` - Delete a specific data file
- **GET** `/api/config` - Get current configuration
- **POST** `/api/config` - Update configuration
- **GET** `/api/health` - Health check endpoint

## 🔍 Troubleshooting

### Common Issues

1. **"No repositories configured"**
   - Click "⚙️ Manage Repos" and add your repository paths
   - Ensure paths are absolute (e.g., `/Users/john/project`)

2. **"No data file found"**
   - Click "Generate Data" for the repository
   - Check that the repository path exists and is accessible
   - Verify the path is a valid git repository with `.git` folder

3. **"Repository path does not exist"**
   - Verify the full absolute path to your git repository
   - Ensure you have read access to the directory
   - For Docker: paths are automatically mapped from `/Users/` to `/mnt/repositories/`

4. **Docker container won't start**
   - Check if Docker is running: `docker info`
   - Try: `docker-compose down && docker-compose up --build`
   - Check logs: `docker-compose logs`

5. **Port already in use**
   - Stop other services using port 3000/3001
   - Or modify the port in docker-compose.yml
   - Kill existing processes: `lsof -ti:3000 | xargs kill -9`

6. **Configuration changes not applied**
   - Refresh the page after saving configuration
   - Check browser console for JavaScript errors
   - Verify configuration syntax is valid JavaScript

### Data Requirements

- **Peer Review**: Requires "Approved-by: Name" in merge commit messages
- **Features/Bugs**: Requires branch prefixes (feature/, bugfix/, hotfix/)
- **Test Coverage**: Detects test file mentions in commit messages
- **Lead Time**: Requires both regular commits and merge commits with PR numbers

### Performance Tips

- **Large Repositories**: Data generation may take longer for repositories with extensive history
- **Memory Usage**: Increase Docker memory limits for very large repositories
- **Storage**: Each repository generates a separate data file for faster switching

## 🔒 Security Considerations

- **Local Access**: Dashboard runs locally and doesn't send data externally
- **File Permissions**: Ensure proper read permissions for repository directories
- **Configuration**: Sensitive information in config.js stays on your local machine
- **Docker Volumes**: Repository data is mounted read-only for security

## 📱 Mobile Support

The dashboard is fully responsive and works on:
- **Desktop**: Full feature set with optimal layout
- **Tablet**: Adapted layout with touch-friendly controls
- **Mobile**: Streamlined interface with collapsible navigation

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch: `git checkout -b feature/amazing-feature`
3. Make your changes and test thoroughly
4. Commit your changes: `git commit -m 'Add amazing feature'`
5. Push to the branch: `git push origin feature/amazing-feature`
6. Submit a pull request

## 📄 License

MIT License - see LICENSE file for details

## 🆘 Support

For issues and questions:
1. Check the troubleshooting section above
2. Review the setup guide and configuration options
3. Check Docker/Node.js logs for error details
4. Ensure repository paths are correct and accessible
5. Verify configuration syntax in the config editor

## 🔄 Updates and Maintenance

- **Regular Updates**: Pull latest changes and rebuild containers
- **Data Refresh**: Regenerate data periodically for latest insights
- **Configuration Backup**: Export configuration before major changes
- **Log Monitoring**: Check application logs for performance insights

---

**Happy Analyzing! 📊✨**

Built with ❤️ for development teams who want to understand their productivity patterns and improve their development processes.