// Git Analytics Configuration
const CONFIG = {
  // URLs & Links
  JIRA_BASE_URL: "https://sample.atlassian.net/browse/",

  // Business Hours Configuration
  BUSINESS_START_HOUR: 8,
  BUSINESS_END_HOUR: 17,
  BUSINESS_DAYS_START: 1, // Monday
  BUSINESS_DAYS_END: 5, // Friday

  // Ticket Prefixes - Add your ticket prefixes here (e.g., 'BDS', 'JIRA', 'PROJ')
  TICKET_PREFIXES: ["BDX", "BX", "EBX"],

  // Auto-generated pattern (don't modify this)
  get TICKET_PATTERNS() {
    return new RegExp(`(${this.TICKET_PREFIXES.join("-\\d+|")}-\\d+)`, "i");
  },

  // Branch Prefixes
  FEATURE_PREFIX: "feature/",
  BUGFIX_PREFIX: "bugfix/",
  HOTFIX_PREFIX: "hotfix/",
  RELEASE_PREFIX: "release/",

  // Chart Colors
  CHART_COLORS: [
    "#e74c3c",
    "#3498db",
    "#2ecc71",
    "#f39c12",
    "#9b59b6",
    "#e67e22",
    "#34495e",
    "#1abc9c",
  ],

  // Lead Time Thresholds (days)
  LEAD_TIME_GOOD_THRESHOLD: 7,
  LEAD_TIME_WARNING_THRESHOLD: 14,

  // Test File Indicators - Add words that indicate test files
  TEST_FILE_INDICATORS: [
    ".test.",
    ".spec.",
    "__tests__",
    "/test/",
    "/tests/",
    "/spec/",
    "/specs/",
    "cypress",
    "e2e",
    "integration",
    "unit",
    "jest",
    "storybook",
    "testing",
  ],

  // Auto-generated pattern (don't modify this)
  get TEST_KEYWORDS() {
    return new RegExp(
      this.TEST_FILE_INDICATORS.map((indicator) =>
        indicator.replace(/[.*+?^${}()|[\]\\]/g, "\\$&")
      ).join("|"),
      "i"
    );
  },

  // Merge Commit Pattern
  MERGE_COMMIT_PATTERN: /^Merged in .+ \(pull request #\d+\)/i,

  // Approved By Pattern
  APPROVED_BY_PATTERN: /Approved-by:\s*([^\n\r]+)/i,
};
