#!/bin/bash

# Git Analytics Dashboard - Docker Runner
echo "🚀 Starting Git Analytics Dashboard..."

# Check if Docker is running
if ! docker info > /dev/null 2>&1; then
    echo "❌ Docker is not running. Please start Docker first."
    echo "💡 Please start Docker to continue"
    exit 1
fi

# Build and run the container
echo "🐳 Building and starting Docker container..."
docker-compose up --build -d

# Wait for container to start
echo "⏳ Waiting for container to start..."
sleep 5

# Check if container is running
if docker-compose ps | grep -q "Up"; then
    echo "✅ Container is running!"
    
    # Open browser (works on macOS and Linux)
    if command -v open &> /dev/null; then
        open http://localhost:3000
    elif command -v xdg-open &> /dev/null; then
        xdg-open http://localhost:3000
    else
        echo "📊 Dashboard is running at: http://localhost:3000"
    fi
    
    echo "✅ Git Analytics Dashboard is ready!"
    echo "🔧 Click 'Manage Repos' to add your git repositories"
    echo "📈 Select repositories from the dropdown to view analytics"
    echo "🛑 To stop: docker-compose down"
else
    echo "❌ Container failed to start. Check logs with: docker-compose logs"
    exit 1
fi